function [rws_filt,ss]=filterrws(lidar)
[na,nr]=size(lidar.RWS);
rws(1:5,1:5)=zeros(5,5);
rws(6:na+5,6:nr+5)=lidar.RWS;
rws(na+6:na+10,nr+6:nr+10)=zeros(5,5);
r=lidar.ranges;
az=lidar.azimuth(:,1);
rwss=lidar.RWS;
for ja=1:na
    for jr=1:nr
        rwst=rws(ja:ja+10,jr:jr+10);
        [nat,nrt]=size(rwst);
        rr=reshape(rwst,1,nat*nrt);
        ss(ja,jr)=std(rr)/mean(rr);
        if abs(ss(ja,jr))>.3
            rwss(ja,jr)=NaN;
        end
    end
end
    rws_filt=rwss;
end